/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.g5.i18n.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class JigsawReflection {
    private static final Class<?> MODULE_CLASS = JigsawReflection.findClass("java.lang.Module");
    private static final Method CLASS_GET_MODULE_METHOD = JigsawReflection.findMethod(Class.class, "getModule", new Class[0]);
    static final Method MODULE_GET_RESOURCE_AS_STREAM_METHOD = JigsawReflection.findMethod(MODULE_CLASS, "getResourceAsStream", String.class);

    private JigsawReflection() {
    }

    static boolean javaLessThan9() {
        return MODULE_CLASS == null;
    }

    static Object getModule(Class<?> clazz) {
        try {
            return CLASS_GET_MODULE_METHOD.invoke(clazz, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Class<?> findClass(final String className) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }
        });
    }

    private static Method findMethod(final Class<?> clazz, final String methodName, final Class<?> ... paramTypes) {
        if (clazz == null) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getDeclaredMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException ex) {
                    return null;
                }
            }
        });
    }
}

