/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.g5.i18n.internal;

import com.e1c.g5.i18n.DefaultString;
import com.e1c.g5.i18n.internal.CurrentLocaleProvider;
import com.e1c.g5.i18n.internal.LocalizedStringLoaderImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;

public class LocalizableInvocationHandler
implements InvocationHandler {
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> itf = this.getLocalizableInterface(proxy);
        String str = LocalizedStringLoaderImpl.loadString(itf, method.getName());
        if (str == null) {
            str = this.getDefaultString(method);
        }
        Locale locale = CurrentLocaleProvider.getLocale();
        if (args != null && args.length > 0) {
            str = this.formatMessage(str, locale, args);
        }
        return str;
    }

    private Class<?> getLocalizableInterface(Object proxy) {
        Class<?>[] interfaces = proxy.getClass().getInterfaces();
        return interfaces[0];
    }

    private String formatMessage(String pattern, Locale locale, Object[] args) {
        MessageFormat mformat = new MessageFormat(pattern, locale);
        return mformat.format(args);
    }

    private String getDefaultString(Method method) {
        DefaultString ds = method.getAnnotation(DefaultString.class);
        return ds.value();
    }
}

