/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.g5.i18n;

import com.e1c.g5.i18n.DefaultString;
import com.e1c.g5.i18n.Localizable;
import com.e1c.g5.i18n.internal.LocalizableInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class LocalizableFactory {
    public static <T> T create(final Class<T> itf) {
        if (!LocalizableFactory.checkInterface(itf)) {
            return null;
        }
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return itf.getClassLoader();
            }
        });
        return itf.cast(Proxy.newProxyInstance(classLoader, new Class[]{itf}, (InvocationHandler)new LocalizableInvocationHandler()));
    }

    private static boolean checkInterface(final Class<?> itf) {
        Method[] methods;
        if (itf == null) {
            throw new IllegalArgumentException("Interface can't be null.");
        }
        if (!itf.isInterface()) {
            throw new IllegalArgumentException(itf.getName() + " isn't interface.");
        }
        if (itf.getAnnotation(Localizable.class) == null) {
            throw new IllegalArgumentException(itf.getName() + " must be annotated with @Localizable");
        }
        Class<?>[] interfaces = itf.getInterfaces();
        if (interfaces.length > 0) {
            throw new IllegalArgumentException(itf.getName() + " can't extend other interfaces");
        }
        for (Method method : methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return itf.getMethods();
            }
        })) {
            if (method.getAnnotation(DefaultString.class) == null) {
                throw new IllegalArgumentException("Method " + method.getName() + "() of interface " + itf.getName() + " is not annotated with @DefaultString.");
            }
            if (method.getReturnType() == String.class) continue;
            throw new IllegalArgumentException("Method " + method.getName() + "() of interface " + itf.getName() + " must return java.lang.String.");
        }
        return true;
    }
}

