/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.g5.i18n.internal;

import com.e1c.g5.i18n.internal.CurrentLocaleProvider;
import com.e1c.g5.i18n.internal.ILocalizedStringLoader;
import com.e1c.g5.i18n.internal.ResourceBundleControl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ClassicLocalizedStringLoader
implements ILocalizedStringLoader {
    private static final Logger LOGGER = Logger.getLogger(ILocalizedStringLoader.class.getName());

    ClassicLocalizedStringLoader() {
    }

    @Override
    public String loadString(Class<?> itf, String key) {
        Locale locale = CurrentLocaleProvider.getLocale();
        try {
            ResourceBundle bundle = ClassicLocalizedStringLoader.getBundle(itf, locale);
            return bundle == null ? null : bundle.getString(key);
        }
        catch (MissingResourceException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Cannot load string with key \"" + key + "\" for bundle \"" + itf.getName() + "\". Current Locale = " + locale.toString());
            }
            return null;
        }
    }

    private static ResourceBundle getBundle(final Class<?> itf, Locale locale) {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return itf.getClassLoader();
            }
        });
        return ResourceBundle.getBundle(itf.getName(), locale, classLoader, new ResourceBundleControl());
    }
}

