/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.g5.i18n.internal;

import com.e1c.g5.i18n.internal.CurrentLocaleProvider;
import com.e1c.g5.i18n.internal.ILocalizedStringLoader;
import com.e1c.g5.i18n.internal.JigsawReflection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class JigsawLocalizedStringLoader
implements ILocalizedStringLoader {
    private static final Logger LOGGER = Logger.getLogger(ILocalizedStringLoader.class.getName());
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private final ConcurrentMap<CacheKey, SoftReference<Properties>> cache = new ConcurrentHashMap<CacheKey, SoftReference<Properties>>();

    JigsawLocalizedStringLoader() {
    }

    @Override
    public String loadString(Class<?> itf, String key) {
        String vf;
        Locale locale = CurrentLocaleProvider.getLocale();
        String v = this.findString(itf, key, locale);
        if (v != null) {
            return v;
        }
        Locale fallback = this.getFallbackLocale(locale);
        if (fallback != null && (vf = this.findString(itf, key, fallback)) != null) {
            return vf;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Cannot load string with key \"" + key + "\" for bundle \"" + itf.getName() + "\". Current Locale = " + locale.toString());
        }
        return null;
    }

    private String findString(Class<?> itf, String key, Locale locale) {
        Object itfModule = null;
        for (Locale candidate : BehaviourControl.getCandidateLocalesList(itf.getName(), locale)) {
            String value;
            Properties p = null;
            CacheKey cacheKey = new CacheKey(itf, candidate);
            SoftReference ref = (SoftReference)this.cache.get(cacheKey);
            if (ref != null) {
                p = (Properties)ref.get();
            }
            if (p == null) {
                if (itfModule == null) {
                    itfModule = JigsawReflection.getModule(itf);
                }
                if ((p = this.loadProperties(itf, itfModule, candidate)) == null) {
                    p = EMPTY_PROPERTIES;
                }
                this.cache.put(cacheKey, new SoftReference<Properties>(p));
            }
            if ((value = p.getProperty(key)) == null) continue;
            return value;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties(Class<?> itf, Object itfModule, Locale locale) {
        InputStream stream;
        String resourceName = this.toResourceName(itf, locale);
        try {
            stream = (InputStream)JigsawReflection.MODULE_GET_RESOURCE_AS_STREAM_METHOD.invoke(itfModule, resourceName);
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            return null;
        }
        if (stream == null) {
            return null;
        }
        try (InputStream in = stream;){
            Properties p = new Properties();
            p.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            Properties properties = p;
            return properties;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private String toResourceName(Class<?> itf, Locale locale) {
        return BehaviourControl.getFileName(itf.getName().replace('.', '/'), locale) + ".properties";
    }

    private Locale getFallbackLocale(Locale locale) {
        Locale currentLocale = CurrentLocaleProvider.getLocale();
        return locale.equals(currentLocale) ? null : currentLocale;
    }

    private static final class BehaviourControl
    extends ResourceBundle.Control {
        private static final BehaviourControl INSTANCE = new BehaviourControl();

        private BehaviourControl() {
        }

        static List<Locale> getCandidateLocalesList(String baseName, Locale locale) {
            return INSTANCE.getCandidateLocales(baseName, locale);
        }

        static String getFileName(String baseName, Locale locale) {
            return INSTANCE.toBundleName(baseName, locale);
        }
    }

    private static final class CacheKey {
        private final Class<?> itf;
        private final Locale locale;

        CacheKey(Class<?> itf, Locale locale) {
            this.itf = itf;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.itf, cacheKey.itf) && Objects.equals(this.locale, cacheKey.locale);
        }

        public int hashCode() {
            return Objects.hash(this.itf, this.locale);
        }
    }
}

