/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.g5.i18n.internal;

import com.e1c.g5.i18n.internal.CurrentLocaleProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ResourceBundleControl
extends ResourceBundle.Control {
    private static final String UTF8_PROPERTIES = "com.e1c.g5.utf8.properties";
    private static final List<String> FORMATS = Collections.singletonList("com.e1c.g5.utf8.properties");

    @Override
    public List<String> getFormats(String baseName) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        return FORMATS;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (baseName == null || locale == null || format == null || loader == null) {
            throw new NullPointerException();
        }
        PropertyResourceBundle bundle = null;
        if (format.equals(UTF8_PROPERTIES)) {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            InputStream is = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    is = connection.getInputStream();
                }
            } else {
                is = loader.getResourceAsStream(resourceName);
            }
            if (is != null) {
                try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    bundle = new PropertyResourceBundle(reader);
                }
            }
        }
        return bundle;
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        Locale currentLocale = CurrentLocaleProvider.getLocale();
        return locale.equals(currentLocale) ? null : currentLocale;
    }
}

