/**************************************************************************
*           Copyright (c) 2000, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    GenDefs.h
*  Date:    8/23/00
*
***************************************************************************
*  NOTE* This file is for PORTABILITY related defines ONLY.
***************************************************************************
*  defines base types to be used by all CVC client components
***************************************************************************/
#ifndef __GENDEFS_H
#define __GENDEFS_H

#ifndef _WIN32

#ifndef USES_CONVERSION
#define USES_CONVERSION
#endif

#define PRELIM_UNIX_PORT

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_STDINT_H
#ifndef CNI_LINUX_INTERFACE
#include <stdint.h>
#endif
#elif HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#ifndef CNI_LINUX_INTERFACE
#include <sys/types.h>
#else
#include <linux/types.h>
#undef _UINTPTR_T_DEFINED
#undef _INTPTR_T_DEFINED
#endif
#endif

#undef FAR
#define FAR
#undef PASCAL
#define PASCAL

#else //_WIN32
#define HAVE_STDINT_H
#include <stdint.h>
#undef HAVE_CONFIG_H
#undef HAVE_SYS_TYPES_H
#define WORDS_BIGENDIAN 0
#if !defined(DWORD)
typedef unsigned long  DWORD;
#endif // !defined(DWORD)

#endif //_WIN32


#undef TRUE
#define TRUE            1

#undef FALSE
#define FALSE           0

#ifdef DDKBUILD //building with the DDK as the source.
#include <crtdefs.h>
#endif

#if !defined(PLATFORM_WIN_APP)
// it'd be nice if we could switch to the C99 standard types at some point...
#if defined(HAVE_STDINT_H) || defined(HAVE_INTTYPES_H)
typedef uint8_t		bool8;
typedef uint16_t	bool16;
typedef uint32_t	bool32;

typedef int8_t		int8;
typedef int16_t		int16;

#if (!defined(CNI_LINUX_INTERFACE) || !defined(CONFIG_ISDN_PPP) || !defined(CONFIG_ISDN_PPP_VJ) || !defined(_SLHC_H)) && !defined(PROTYPES_H)
typedef int32_t 	int32;
#endif

typedef uint8_t		uint8;
typedef uint16_t	uint16;

#if !defined(CSSMAPI) && !defined(PROTYPES_H)
#ifdef _WIN32
typedef unsigned long uint32;
#else
typedef uint32_t	uint32;
#endif
#endif

typedef uint64_t	uint64;
#else

typedef unsigned char   uint8;
typedef unsigned short  uint16;
#ifndef CSSMAPI
typedef unsigned long   uint32;
#endif
typedef unsigned char   uint8_t;
typedef unsigned short  uint16_t;
#if defined(_WIN32) && !defined (HS_TYPES_H_)
typedef unsigned long   uint32_t;
#endif

#ifdef _WIN32
typedef __int64                    int64;
typedef unsigned __int64           uint64;
typedef __int64                    int64_t;
typedef unsigned __int64           uint64_t;
#else
typedef long long                  int64;
typedef unsigned long long int     uint64;
typedef long long                  int64_t;
typedef unsigned long long int     uint64_t;
#endif
#endif

// Definitions for Windows not available in <stdint.h>
#ifdef _WIN32
typedef unsigned long   bool32_t;
typedef unsigned char   bool8_t;
#endif

// integer types for doing pointer arithmetic, they should be the
// same size as a pointer. Part of the C99 standard, but they aren't
// available everywhere yet.
// These defs should work with IA32 (x86), ILP32 (sparcv8) and LP64 (sparcv9).
// These types are protected with the WIN32 macros (_INTPTR_T_DEFINED), since
// some, but not all of the WIN32 SDK's define these types.
#ifdef _WIN32
#ifndef _INTPTR_T_DEFINED
#if defined(_LP64)
#warning 64 bit
typedef int64 intptr_t;
#else
typedef int32 intptr_t;
#endif
#define _INTPTR_T_DEFINED
#endif

#ifndef _UINTPTR_T_DEFINED
#if defined(_LP64)
#warning 64 bit
typedef uint64 uintptr_t;
#else
typedef uint32 uintptr_t;
#endif
#define _UINTPTR_T_DEFINED
#endif
#endif

#ifndef __OBJC__   /* Mac OS X defines this in ObjectiveC land... */
typedef int 	BOOL;
#endif

#ifndef _WIN32
typedef int 	BOOLEAN;
#endif

#ifdef _WIN32
typedef int mode_t;
#endif

typedef	unsigned char   uchar;
#ifndef HAVE_SYS_TYPES_H
typedef unsigned int    uint;
typedef unsigned short  ushort;
typedef unsigned long   ulong;
#endif

#ifndef PLATFORM_ANDROID
typedef ulong   ULONG;
typedef ulong*  PULONG;
#endif

#if defined(PLATFORM_ANDROID)
typedef unsigned long ulong;
typedef unsigned short ushort;
#endif

typedef uint32  DWORD;
typedef uint32* PDWORD;
typedef long    LONG;
typedef long*   PLONG;
typedef int     INT;
typedef int*    PINT;
typedef uint    UINT;
typedef uint*   PUINT;
typedef uint16  USHORT;
typedef uint16* PUSHORT;
typedef int16   SHORT;
typedef int16*  PSHORT;
typedef uint16  WORD;
typedef uint16* PWORD;
typedef char    CHAR;
typedef uchar   UCHAR;
typedef char*   PCHAR;
typedef uint8   BYTE;
typedef uint8*  PBYTE;
#define         VOID  void
typedef void*   PVOID;
#ifdef _WIN32
typedef void*   HANDLE;
#else
typedef int     HANDLE;
typedef int     SOCKET;
typedef const char*   LPCTSTR;
typedef const char*   LPCSTR;
typedef const char*   PCTSTR;
typedef char*   LPTSTR;
typedef void*   LPVOID;
typedef char*   LPSTR;
typedef long*   LPLONG;
typedef DWORD*  LPDWORD;
typedef signed int INT32;


typedef struct __WSABUF
{
    unsigned long len;
    char *buf;
} WSABUF, *LPWSABUF;

typedef struct OVERLAPPED
{
    void *data;
    int fd;
} OVERLAPPED,*LPOVERLAPPED;

typedef struct sockaddr_in SOCKADDR_IN;
typedef struct sockaddr_in6 SOCKADDR_IN6;

#endif //!_WIN32

typedef HANDLE* PHANDLE;
typedef uint8   KIRQL;
#else // PLATFORM_WIN_APP
typedef unsigned long bool32;
typedef unsigned long bool32_t;
typedef unsigned long ulong;
typedef unsigned char BYTE;
typedef unsigned long uint32;
typedef long int32;
#endif // !defined(PLATFORM_WIN_APP)

typedef long STATUSCODE;

/* function parameter context */
#undef  IN
#define IN

#undef  OUT
#define OUT

#undef  INOUT
#define INOUT

#undef  packed
#define packed

#ifndef CLEAR
#define CLEAR(a)			memset(&a,0,sizeof(a))
#endif

#ifndef POINT_BEYOND
#define POINT_BEYOND(a,t)	(t) &((&a)[1])
#endif

#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif

#ifndef _WIN32
#define _ftime ftime
#define _timeb timeb
#define __cdecl
#define __stdcall
#ifndef __fastcall
#define __fastcall
#endif
#ifndef WINAPI
#define WINAPI
#endif
#ifndef CALLBACK
#define CALLBACK
#endif
#endif

#ifndef _WIN32
#undef  INVALID_SOCKET
#define INVALID_SOCKET -1
#undef  INVALID_FD
#define INVALID_FD -1
#undef  SOCKET_ERROR
#define SOCKET_ERROR -1
#undef  SOCKADDR
#define SOCKADDR sockaddr
#undef  SOCKADDR_IN
#define SOCKADDR_IN sockaddr_in
#undef  SOCKADDR_IN6
#define SOCKADDR_IN6 sockaddr_in6

#if defined(PLATFORM_DARWIN) || defined(PLATFORM_APPLE_SSLVPN) || defined(APPLE_IOS) || defined(PLATFORM_CHROMEBOOK)
#define s6_words __u6_addr.__u6_addr16
#elif defined(PLATFORM_LINUX)
#define s6_words s6_addr16
#endif

#endif

#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE
#endif


#if !defined(_WIN32)

#ifndef ZeroMemory
#define ZeroMemory ZEROMEM
#ifndef PLATFORM_ANDROID
    #define ZEROMEM(ptr,cnt) \
        if ( NULL != ptr ) { memset(ptr,0,cnt); }
#else
    // Cius compiler will generate a compilation error for: if( &var )
    #define ZEROMEM(ptr,cnt) \
    { \
        void *pZero = ptr; \
        if ( NULL != pZero ) { memset(pZero,0,cnt); } \
    }
#endif /* !PLATFORM_ANDROID */
#endif  /* ZeroMemory */

#ifndef SecureZeroMemory
#define SECUREZEROMEM(ptr, cnt) \
    do { \
        size_t size = (size_t)cnt; \
        volatile char *vptr = (volatile char *)ptr; \
        while (size) { \
            *vptr = 0; \
            vptr++; \
            size--; \
        } \
    } while(0);
#define SecureZeroMemory SECUREZEROMEM
#endif  /* SecureZeroMemory */
#endif  /* Windows */



#ifndef _WIN32
#define _strnicmp strncasecmp
#define _stricmp  strcasecmp
#endif

#if !defined(UINT16_MAX)
#define UINT16_MAX 0xffffu
#endif

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(a) (sizeof(a)/sizeof(a[0]))
#endif

#if !defined(TO_STR) && !defined(TO_TSTR) && !defined(SYMBOL_TO_STR) && !defined(SYMBOL_TO_TSTR)

// use TO_STR(x)/TO_TSTR(x) to stringize (put double quotes around) x
//  example:
//    std::string foo = TO_STR(15);
//    tstring bar = TO_TSTR(15);
//  becomes
//    std::string foo = "15";
//    tstring bar = _T("15");
#define TO_STR(x) #x
#define TO_TSTR(x) _T(#x)

// use SYMBOL_TO_STR(x)/SYMBOL_TO_TSTR(x) to stringize
// the definition of symbol x
//  example:
//    #define MAX_LEN 15
//    std::string foo = SYMBOL_TO_STR(MAX_LEN);
//    tstring bar = SYMBOL_TO_TSTR(MAX_LEN);
//  becomes
//    std::string foo = "15";
//    tstring bar = _T("15");
//
// Note that TO_STR(MAX_LEN) results in "MAX_LEN".  The double macro is required in
// order to strinigize the *definition* of a symbol (as opposed to the symbol itself)
#define SYMBOL_TO_STR(x)  TO_STR(x)
#define SYMBOL_TO_TSTR(x) TO_TSTR(x)

#endif

#ifdef _WIN32
#define systemtime_t __time64_t
#define getSystemTimeInSeconds()    _time64(NULL)
#else
#define systemtime_t time_t
#define getSystemTimeInSeconds()    time(NULL)
#endif

#ifndef _WIN32
#ifndef INFINITE
#define INFINITE 0xFFFFFFFF
#endif
#endif

#ifdef _WIN32
#define ANY_PATHNAME_DELIMITER "/\\"
#define PATHNAME_DELIMITER  '\\'
#define PATHNAME_DELIMITER_STR  "\\"
#else
#define ANY_PATHNAME_DELIMITER "/"
#define PATHNAME_DELIMITER  '/'
#define PATHNAME_DELIMITER_STR  "/"
#endif
#define URL_URI_DELIMITER  '/'
#define URL_URI_DELIMITER_STR  "/"

#ifdef _WIN32
#define NEWLINE "\r\n"
#else
#define NEWLINE "\n"
#endif

#if defined(_WIN32)
#define HOSTSFILE_LOCATION _T("drivers\\etc\\hosts")
#else
#define HOSTSFILE_LOCATION _T("/etc/hosts")
#endif

#ifdef _WIN32
#define DebugWriteFile(_handle_,_buffer_,_length_,_refCharsWritten_)  \
        WriteFile((_handle_),(_buffer_),(_length_),(_refCharsWritten_),NULL)
#else
#ifndef INVALID_HANDLE_VALUE
#define INVALID_HANDLE_VALUE    NULL
#endif
#define DebugWriteFile(_handle_,_buffer_,_length_,_refCharsWritten_)  \
        fprintf((_handle_), "%s", (_buffer_)); \
        fflush((_handle_))
#endif

typedef uint8_t MAC_ADDR[6];

#if !defined(_WIN32) || defined(_WIN32_WCE)
#ifndef ADDRESS_FAMILY
typedef unsigned short ADDRESS_FAMILY;
#endif
#endif

#if __cplusplus >= 201103L
#define CPP_11_SUPPORTED
#endif
#if __cplusplus >= 201402L
#define CPP_14_SUPPORTED
#endif
#if __cplusplus >= 201703L
#define CPP_17_SUPPORTED
#endif

#if ((defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX)) && !defined(ANYCONNECT_USE_SNAK) && !defined(PRODUCT_TYPE_SSA)
/*
 ** the FIREWALL_SUPPORTED define is used to track the platforms
 ** where the firewall feature is supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 ** Also, when Firewall feature expands to other platforms, they only need to be added in
 ** one place.
 */
#define FIREWALL_SUPPORTED
#endif

#if !defined(PRODUCT_TYPE_SSA) && ((defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(PLATFORM_CHROMEBOOK)))
/*
** the TRUSTED_NETWORK_DETECTION define is used to track the platforms
** where Trusted Network Detection is performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
** Also, when TND support expands to other platforms, they only need to be added in
** one place.
*/
#define TRUSTED_NETWORK_DETECTION

/*
 * Android only uses TND to report state to NVM.
 * Policy-based actions are not supported.
 */
#if !defined(PLATFORM_ANDROID)
#define TND_ACTIONS_SUPPORTED
#endif
#endif

#if (defined(_WIN32) || defined(PLATFORM_DARWIN) || defined(PLATFORM_ANDROID) || defined(PLATFORM_LINUX) && !defined(ANYCONNECT_USE_SNAK) && !defined(PLATFORM_WIN_APP))
#define INTER_MODULE_STATE_NOTIFY
#endif

#if ((defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN) || defined(TRUSTED_NETWORK_DETECTION)) && !defined(PRODUCT_TYPE_SSA) && !defined(PLATFORM_ANDROID)
/*
** the LOGIN_UTILITIES_SUPPORTED define is used to track the platforms
** that support AnyConnect action triggered by user login. This is to avoid
** repeating the platforms in #ifdef clauses in other files.
** Also, when login support expands to other platforms, they only need to be added in
** one place.
*/
#define LOGIN_UTILITIES_SUPPORTED
#endif

#if (defined(_WIN32) || defined(PLATFORM_DARWIN)) && !defined(PLATFORM_WIN_APP)
/*
** The DNS_PLUGIN_SUPPORTED define is used to track the platforms where the DNS KDF plugin is 
** available. This is to avoid repeating the platforms in #ifdef clauses in other files.
** Also, when support expands to other platforms, they only need to be added in one place.
*/
#define DNS_PLUGIN_SUPPORTED
#if defined(_WIN32)
/*
** The DNS_PLUGIN_DNS_REQ_HANDLING_SUPPORTED define is used to track the platforms where the DNS KDF plugin is 
** available and supports handling of DNS requests during the VPN tunnel (e.g. for split-DNS or tunnel-all-DNS enforcement).
**/
#define DNS_PLUGIN_DNS_REQ_HANDLING_SUPPORTED
#endif // _WIN32
#endif // (_WIN32 || PLATFORM_DARWIN) && !PLATFORM_WIN_APP && !PRODUCT_TYPE_SSA

#if defined(DNS_PLUGIN_SUPPORTED)
/*
** The DYNAMIC_SPLIT_TUNNELING_SUPPORTED define is used to track the platforms where dynamic split tunneling is supported.
**/
#define DYNAMIC_SPLIT_TUNNELING_SUPPORTED
#endif // DNS_PLUGIN_SUPPORTED

#if !(defined(PLATFORM_APPLE_SSLVPN) && TARGET_CPU_ARMV6)
/*
** A bug was discovered in iPhone testing wherein virtual inline functions do
** not work correctly on ARMv6 processors. To work around this, virtual inline
** function need to be made standard virtual functions on ARMv6. To prevent
** differences in runtime behavior, the VIRTUAL_INLINES_SUPPORTED define is used
** to define some virtual inlines in the header files, letting the functions be
** defined without the inline type in the cpp file for non-supported platforms.
*/
#define VIRTUAL_INLINES_SUPPORTED
#endif

/*
 * When changing the SCRIPTING_SUPPORTED definition, you MUST also update the
 * ClientIfcBase.h!  We duplicate this definition there due to the manner in
 * which we distribute our code to partners; we cannot include this header from
 * ClientIfcBase.h.
 */
#if !defined(PLATFORM_APPLE_SSLVPN) && !defined(PLATFORM_ANDROID) && !defined(PLATFORM_WIN_APP)
/*
** the SCRIPTING_SUPPORTED define is used to enable the script manager for launching
** customer provided scripts on events like connection establishment, completion of
** disconnect, and captive portal detection.
*/
#define SCRIPTING_SUPPORTED
#endif

#if defined(PLATFORM_ANDROID)
#define DYNAMIC_UPDATE_LOCAL_POLICY
#endif // PLATFORM_ANDROID

#if !defined(PRODUCT_TYPE_SSA) && ((defined(_WIN32) && !defined(_WIN32_WCE)  && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(ANYCONNECT_USE_SNAK)))
/*
** the NETWORK_ENVIRONMENT_STATE define is used to track the platforms
** where NETWORK_ENVIRONMENT_STATE check is performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
** Also, when NES support expands to other platforms, they only need to be added in
** one place.
*/
#define NETWORK_ENVIRONMENT_STATE
#endif


#if (defined(_WIN32) && !defined(_WIN32_WCE)  && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(ANYCONNECT_USE_SNAK))
/*
** The AUTOMATIC_HEADEND_SELECTION define is used to track the platforms
** where Automatic Headend Selection is performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
** Also, when AHS support expands to other platforms, they only need to be added in
** one place.
*/
#define AUTOMATIC_HEADEND_SELECTION
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN)
/*
 ** the MUS_HOST_SERVICES define is used to track the platforms
 ** where MUS Host Status check is performed. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 */
#define MUS_HOST_SERVICES
#endif

// BUGBUG - initially only enable code signing for Windows
#if (defined(_WIN32) && !defined(_WIN32_WCE)  && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(PLATFORM_LINUX_EMBEDDED_PPC) && !defined(PLATFORM_LINUX_EMBEDDED_ARM) && !defined(PLATFORM_ANDROID) && !defined(PLATFORM_CHROMEBOOK))
/*
 ** the CODE_SIGNING_SUPPORTED define is used to track the platforms 
 ** where code sign verification is support. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 **
 */
#define CODE_SIGNING_SUPPORTED
#endif

#if defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP)
#define RSA_SECURID_SUPPORTED
#endif

#if defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP)
#define SAFEWORD_SOFTOKEN_SUPPORTED
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE)  && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX) || defined(PLATFORM_APPLE_SSLVPN) || ( defined(PRODUCT_TYPE_SSA) && defined(APPLE_IOS) )
/*
 ** the IPSEC_SUPPORTED define is used to track the platforms 
 ** where the IPSec protocol is supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 */
#define IPSEC_SUPPORTED
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(PLATFORM_CHROMEBOOK)) || defined(PLATFORM_APPLE_SSLVPN) || defined (PLATFORM_ANDROID)
/*
 ** The IPV6_SUPPORTED define is used to track the platforms 
 ** where full IPv6 capability is supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 ** Note that this is further narrowed down by method CIPv6Util::IsIPv6FullCapabilitySupported.
 */
#define IPV6_SUPPORTED
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX) || defined(PLATFORM_APPLE_SSLVPN) || ( defined(PRODUCT_TYPE_SSA) && defined(APPLE_IOS) )
/*
 ** the PLUGIN_PROTOCOL_SUPPORTED define is used to track the platforms 
 ** where modular protocol Plugins are supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 */
#define PLUGIN_PROTOCOL_SUPPORTED
#endif

#if defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP) && !defined(PRODUCT_TYPE_SSA)
/*
** The IPSEC_OVER_SSL define is used to track the platforms 
** where the feature "IPsec tunneling over SSL for Oracle" (EDCS-852737) is supported. 
** This is to avoid repeating the platforms in #ifdef clauses in other files.
** Also, when the support expands to other platforms, they only need to be added in
** one place.
*/
#define IPSEC_OVER_SSL
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(PLATFORM_ANDROID) && !defined(PLATFORM_CHROMEBOOK)) || defined(APPLE_IOS)
/*
 ** the DATA_OBFUSCATING_SUPPORTED define is used to track the platforms 
 ** where data obfuscation using key exchanges are supported. This is to
 ** avoid repeating the platforms in #ifdef clauses in other files.
 */
#define DATA_OBFUSCATING_SUPPORTED
#endif

#if !defined(PLATFORM_APPLE_SSLVPN) && !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP) && !defined(PRODUCT_TYPE_SSA) && !defined(PLATFORM_ANDROID) && !defined(PLATFORM_CHROMEBOOK)
/*
** the HOSTFILE_MODIFICATION_SUPPORTED define is used to track the platforms
** where hosts file modification is performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define HOSTSFILE_MODIFICATION_SUPPORTED
#endif

#if defined(_WIN32) || defined(_WIN32_WCE) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX) || defined(PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN)|| defined(PLATFORM_WIN_APP)
/*
** the SCEP_CERTIFICATE_ENROLLMENT_SUPPORTED define is used to track the platforms
** where SCEP enrollment can be performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define SCEP_CERTIFICATE_ENROLLMENT_SUPPORTED
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE))
/*
** these XXX_PROFILE_SUPPORTED defines are used to track the platforms where
** Service Profiles for optional modules are supported.
** All platforms: VPN
** Windows: NAM, Web Security, ISE Posture, FireAMP, NVM and OpenDNS
 */
#define NAM_PROFILE_SUPPORTED
#define WEBSEC_PROFILE_SUPPORTED
#define ISEPOSTURE_PROFILE_SUPPORTED
#define FIREAMP_PROFILE_SUPPORTED
#define NVM_PROFILE_SUPPORTED
#define OPENDNS_PROFILE_SUPPORTED
#elif defined(PLATFORM_DARWIN)
/*
** OS X: Web Security, ISE Posture, FireAMP, NVM and OpenDNS
*/
#define WEBSEC_PROFILE_SUPPORTED
#define ISEPOSTURE_PROFILE_SUPPORTED
#define FIREAMP_PROFILE_SUPPORTED
#define NVM_PROFILE_SUPPORTED
#define OPENDNS_PROFILE_SUPPORTED
#elif defined(PLATFORM_LINUX)
#define NVM_PROFILE_SUPPORTED
#endif

#if defined(_WIN32) || defined(PLATFORM_DARWIN)
/*
** the CLOUD_UPDATE_SUPPORTED define is used to track the platforms
** that support cloud updates (currently from OpenDNS). This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define CLOUD_UPDATE_SUPPORTED
#endif

/*
** The PLATFORM_DESKTOP define is used to track AnyConnect desktop platforms.
*/
#if (defined(_WIN32) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(ANYCONNECT_USE_SNAK) && !defined (PLATFORM_ANDROID) && !defined(PLATFORM_CHROMEBOOK))) \
    && !defined(PRODUCT_TYPE_SSA) && !defined(PLATFORM_WIN_APP)
#define PLATFORM_DESKTOP
#endif

#if defined(PLATFORM_DESKTOP)
/*
** The exportStats call is only supported on the Desktop Platforms,
** it should not be included or supported if it is not a Desktop Plat
*/
#define EXPORT_STATS_SUPPORTED
#endif

#if defined(_WIN32) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX) || defined(PLATFORM_APPLE_SSLVPN)
#define AC_CERTIFICATE_POLICY_SUPPORTED
#endif

#ifndef _TRSTRING
#define _tr(String) String
#define _TRSTRING
#endif

#ifndef _C_MYASSERT
#define C_MYASSERT(e) typedef char __C_MYASSERT__[(e)?1:-1]
#define _C_MYASSERT
#endif

#if defined(PLATFORM_APPLE_SSLVPN) || defined(APPLE_IOS)
#define NETWORK_ORDER_LOOPBACK_INTF_ADDR    htonl(0x7f000001) // 127.0.0.1
#endif

#if !defined(BITS_PER_BYTE)
#define BITS_PER_BYTE   8
#endif

#if defined(PLATFORM_DESKTOP) && defined(PLATFORM_LINUX)
#define STATIC_THREAD_LOCAL static __thread
#else
#define STATIC_THREAD_LOCAL thread_local
#endif

#if defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_ANDROID) || defined(PLATFORM_CHROMEBOOK)|| defined(PRODUCT_TYPE_SSA) || defined(PLATFORM_WIN_APP)
/*
 ** the MANUAL_PKCS12_IMPORT_SUPPORTED define is used to track the platforms 
 ** where the manual import of PKCS12 certificates is supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 */
#define MANUAL_PKCS12_IMPORT_SUPPORTED
#endif

#if defined(PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_CHROMEBOOK)
// Zlib is statically linked.
#define STATIC_ZLIB
#endif

#if (defined(PLATFORM_LINUX) && !defined(PLATFORM_ANDROID)) || defined(PLATFORM_DARWIN)
// Use zlib dynamic library on the system.
#define USE_SYSTEM_ZLIB
#endif


/*
 * Platforms that support a single profile.
 */
#if defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_ANDROID) || defined(PLATFORM_CHROMEBOOK)
#define USE_SINGLE_PROFILE
#endif


/*
 * Platforms that support ACIDEX.
 */
#if defined(PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN) || defined(_WIN32) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX)  || defined(PLATFORM_CHROMEBOOK)
#define ACIDEX_SUPPORTED
#endif

/*
 * Platforms that support PerApp.
 */
#if defined(PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN)
#define PERAPP_SUPPORTED
#endif


/*
 * Platforms that support HOSTDATA.
 */
#if defined(PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_CHROMEBOOK)
#define HOST_DATA_SUPPORTED
#endif


/*
 * Platforms that support scripting.
 *
 * When changing the SCRIPTING_SUPPORTED definition, you MUST also update the
 * ClientIfcBase.h!  We duplicate this definition there due to the manner in
 * which we distribute our code to partners; we cannot include this header from
 * ClientIfcBase.h.

 */
#if !defined(PLATFORM_APPLE_SSLVPN) && !defined(PLATFORM_ANDROID) && !defined(PLATFORM_WIN_APP)
#define SCRIPTING_SUPPORTED
#endif

#if defined(PLATFORM_ANDROID)
// On Android, modifying the default route may break system network services.
#define DONT_TOUCH_IPV4_DEFAULT_ROUTE
#endif

#if defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_ANDROID) || defined(PLATFORM_CHROMEBOOK)
#define SNAK_NO_ROUTE_TABLE_ACCESS
#endif

#if defined(ANYCONNECT_USE_SNAK) || defined(PLATFORM_APPLE_SSLVPN)
#define GLOBAL_SNAK_PLUGIN_VER              2
#endif

#if defined(PLATFORM_ANDROID)
// Supports API for integrating program data (e.g. localization and profile).
#define PROGRAM_DATA_IMPORT_SUPPORTED
#endif

#if defined(PLATFORM_ANDROID)
// Credentials for a connection can be prefilled via uri handling or API calls
// if you add a new platform, you need to add it in ClientIfcBase.h and ConnectPromptInfoBase.h
#define CREDENTIAL_PREFILL_SUPPORTED
#endif

#if !(defined(_WIN32_WCE) || defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_ANDROID) || defined(PLATFORM_CHROMEBOOK))
// support for automatic reconnects
#define AUTORECONNECT_SUPPORTED
#endif

#if !defined(_WIN32_WCE) && !defined(PLATFORM_LINUX_EMBEDDED_PPC) && !defined(PLATFORM_WEBOS_ARM) && !defined(PLATFORM_WEBOS_X86) && !defined(APPLE_IOS) && !defined(PLATFORM_WIN_APP) && !defined(_DOWNLOADER)
#define FIPS_SUPPORTED
#endif

#if !defined(_WIN32_WCE) && !defined(PLATFORM_WIN_APP)  && !defined(PLATFORM_APPLE_SSLVPN) && !defined(PLATFORM_LINUX_EMBEDDED_PPC) && !defined(PLATFORM_WEBOS_ARM) && !defined(PLATFORM_WEBOS_X86) && !defined(APPLE_IOS) && !defined(PRODUCT_TYPE_SSA) && !defined(PLATFORM_CHROMEBOOK)
#define LEAF_SUPPORTED
#endif

#if defined(PLATFORM_DESKTOP) && (defined(_WIN32) || defined(PLATFORM_LINUX))
/*
** This define is used to track platforms where user logon 
** related preferences in client profile are supported.
*/
#define ENFORCE_USER_LOGON_SETTINGS 
#endif

#if !defined(PLATFORM_ANDROID) && !defined(PLATFORM_CHROMEBOOK) // More platforms need to be added
#define WIDE_CHAR_SUPPORTED
#endif

#if defined(_WIN32) && !defined(PRODUCT_TYPE_SSA) && !defined(PLATFORM_WIN_APP)
#define TUNNEL_PROXY_SETTINGS_SUPPORTED
#endif

/*
** Public Proxy support is only implemented on Windows, Linux and Mac desktop platforms
*/
#if defined(PLATFORM_DESKTOP)
#define PUBLIC_PROXY_SUPPORTED
#endif

/*
** NTLM support is only implemented on Windows desktop platforms
*/
#if defined(_WIN32) && defined(PUBLIC_PROXY_SUPPORTED)
#define PROXYAUTH_NTLM_SUPPORTED
#endif

#if defined(PLATFORM_ANDROID) || defined(PRODUCT_TYPE_SSA) || defined(PLATFORM_APPLE_SSLVPN)
#define IMPORT_API_SUPPORTED
#endif

#if defined(PLATFORM_APPLE_SSLVPN)  || (defined(PRODUCT_TYPE_SSA) && !(defined(PLATFORM_ANDROID) || defined(APPLE_IOS)))  || defined(PLATFORM_CHROMEBOOK)
/*
** This serves to tell the IPsec plugin interface to explicitly
** exclude it's global namespace entry points, leaving the only
** plugin interface as a set of static class methods, which the
** loading code will look for directly.
*/
#define IPSEC_AS_INTERNAL_MODULE
#endif

#if defined(PLATFORM_ANDROID) // More platforms need to be added
#define dynamic_cast reinterpret_cast
#endif

#if defined(PRODUCT_TYPE_SSA) && defined(APPLE_IOS) && !defined(PLATFORM_APPLE_SSLVPN)
#define CONFIGURE_REMOTE_WAKEUP_SUPPORTED
#endif

/*
** The SMARTCARD_SUPPORTED define is used to track the platforms where smartcard
** certificate authentication is supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#if (defined(_WIN32) && !defined(PLATFORM_WIN_APP)) || defined(PLATFORM_DARWIN)
#define SMARTCARD_SUPPORTED
/*
** The SMARTCARD_REMOVAL_SUPPORTED define is used to track the platforms where smartcard
** removal monitoring is supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#if defined(_WIN32)
#define SMARTCARD_REMOVAL_SUPPORTED
#endif
#endif // (_WIN32 && !PLATFORM_WIN_APP) || PLATFORM_DARWIN

#if (defined(PLATFORM_LINUX) || defined(PLATFORM_DARWIN)) && !defined(ANYCONNECT_USE_SNAK) && !defined(PRODUCT_TYPE_SSA)
/*
 ** The CIRCUMVENT_HOST_FILTERING_SUPPORTED define is used to track the platforms
 ** where AnyConnect can control whether or not pre-existing host filtering is
 ** circumvented upon applying AnyConnect filtering (only applicable to split-tunneling). 
 */
#define CIRCUMVENT_HOST_FILTERING_SUPPORTED
#endif

#if defined(PLATFORM_LINUX) && defined(PLATFORM_DESKTOP)
/*
 ** The TUNNEL_FROM_ANY_SOURCE_SUPPORTED define is used to track the platforms
 ** where admin can control whether or not to allow packets from any source addresses
 ** being tunneled. 
 */
#define TUNNEL_FROM_ANY_SOURCE_SUPPORTED
#endif

#if defined(_WIN32) && !defined(ANYCONNECT_USE_SNAK) && !defined(PRODUCT_TYPE_SSA)
/*
 ** The SKIP_DHCP_SERVER_ROUTE_SUPPORTED define is used to track the platforms
 ** where the admin can control whether or not the public DHCP server route is created
 ** upon establishing the VPN tunnel. 
 */
#define SKIP_DHCP_SERVER_ROUTE_SUPPORTED
#endif

#if defined(PLUGIN_PROTOCOL_SUPPORTED) && !defined(PRODUCT_TYPE_SSA)
#if (defined(_WIN32) && !defined(_WIN32_WCE))
// support Service Control Plugins if defined
#define SERVICE_PLUGIN
// support PhoneHome Plugin if defined
#define PHONEHOME_PLUGIN
#elif defined(PLATFORM_DARWIN)
// support Service Control Plugins if defined
#define SERVICE_PLUGIN
// support PhoneHome Plugin if defined
#define PHONEHOME_PLUGIN
#elif defined(PLATFORM_LINUX) && !defined(PLATFORM_ANDROID) && !defined(PLATFORM_CHROMEBOOK)
#define PHONEHOME_PLUGIN
#define SERVICE_PLUGIN
#endif
#endif

#if (defined (PLATFORM_DARWIN) || defined (PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_CHROMEBOOK) || (defined (PLATFORM_LINUX) && !defined (ANYCONNECT_USE_SNAK)))
#define FILE_STORE_SUPPORTED
#endif

#if !defined(PLATFORM_WIN_APP)
/*
** the INTERPROCESS_COMMUNICATION_SUPPORTED define is used to track the platforms where the
** communication between processes is supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define INTERPROCESS_COMMUNICATION_SUPPORTED
#endif
#if !defined(PLATFORM_WIN_APP)
/*
** the THREADS_SUPPORTED define is used to track the platforms where
** threads are supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define THREADS_SUPPORTED
#endif

#if !defined(PLATFORM_WIN_APP)
/*
** the CAPTIVE_PORTAL_DETECTION_SUPPORTED define is used to track the platforms where
** captive portal detection is supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define CAPTIVE_PORTAL_DETECTION_SUPPORTED
#endif

#if defined(_WIN32) && defined(CAPTIVE_PORTAL_DETECTION_SUPPORTED) && defined(PLATFORM_DESKTOP)  
/*
** the SECURE_CAPTIVE_PORTAL_REMEDIATION_SUPPORTED define is used to track the platforms where
** secure captive portal remediation is supported.
*/
#define SECURE_CAPTIVE_PORTAL_REMEDIATION_SUPPORTED
#endif

#if !defined(PLATFORM_WIN_APP)
/*
** the EVENTS_SUPPORTED define is used to track the platforms where
** events are supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define EVENTS_SUPPORTED
#endif

#if defined(IPV6_SUPPORTED) && !defined(PLATFORM_WIN_APP) && !defined(PLATFORM_ANDROID) && !defined(PLATFORM_CHROMEBOOK) && !defined(PLATFORM_APPLE_SSLVPN)
/*
** the MODIFY_HOSTSFILE_SUPPORTED define is used to track the platforms where
** modification of the system's hosts file is supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define MODIFY_HOSTSFILE_SUPPORTED
#endif

#if !defined(PLATFORM_WIN_APP)
/*
** the HOST_CONFIG_MANAGER_SUPPORTED define is used to track the platforms where
** broad control of the host OS is supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define HOST_CONFIG_MANAGER_SUPPORTED
#endif

#if defined(PRODUCT_TYPE_SSA) || defined(PLATFORM_WIN_APP) ||  defined(PLATFORM_ANDROID) || defined(PLATFORM_CHROMEBOOK) || defined(PLATFORM_APPLE_SSLVPN)
/*
** the FILE_SYNCHRONIZER_SUPPORTED define is used to track the platforms where
** files downloaded directly by VPN API are supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define FILE_SYNCHRONIZER_SUPPORTED
#endif

#if defined(_WIN32) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(PLATFORM_ANDROID) && !defined(PLATFORM_CHROMEBOOK))
/*
 ** the SAVE_VPNCONFIG_TO_FILE_SUPPORTED define is used to track the platforms where the
 ** writting of the VPN config to file is supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 */
#define SAVE_VPNCONFIG_TO_FILE_SUPPORTED
#endif

/*
*  DSCP preservation is not considered for Downloader. Downloader uses socket transport for IPC.
*/
#if (defined(PLATFORM_ANDROID) || defined(PLATFORM_DARWIN) || defined(_WIN32)) && !defined(_DOWNLOADER) && !defined(PRODUCT_TYPE_SSA) && !defined(PLATFORM_WIN_APP)
// Used to enable preservation of Differentiated Services field in the IP packet header.
#define DIFFSERV_PRESERVATION_SUPPORTED
#endif

#if !defined(PRODUCT_TYPE_SSA) && !defined(PLATFORM_WIN_APP)
/*
** the ROUTE_MANAGER_SUPPORTED define is used to track the platforms
** where RouteMgr is supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define ROUTE_MANAGER_SUPPORTED
#endif

#if !defined(PRODUCT_TYPE_SSA) && !defined(PLATFORM_WIN_APP)
/*
** the FILTER_MANAGER_SUPPORTED define is used to track the platforms
** where FilterMgr is supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define FILTER_MANAGER_SUPPORTED
#endif

#if defined(PLATFORM_APPLE_SSLVPN)
// Used to enable the file logging for Apple plugins.
//#define FILE_LOGGING_SUPPORTED
#endif

/*
** Legacy Single sign on authentication.
** Explicitly disabled on mobile platforms due to session fixation vulnerability, as described in CSCvg65072
** To be removed from desktop platforms in some future AnyConnect release (4.7?)
*/
#if defined(PLATFORM_DESKTOP)
#define SSO_V1_SUPPORTED
#endif

/*
** Single sign on authentication (requires embedded browser).
*/
#if !defined(PLATFORM_WIN_APP)
#define SSO_SUPPORTED
#endif

#if !defined(PLATFORM_WIN_APP)
#define MCA_SUPPORTED
#endif

#if !defined(PLATFORM_WIN_APP)
#define TIMERS_SUPPORTED
#endif

#if !defined(PLATFORM_CHROMEBOOK)
#define LOAD_EXTERNAL_MODULES
#endif

#if defined(PLATFORM_ANDROID)
#define SPLIT_DNS_PROXY_SUPPORTED
#endif

#if (defined(_WIN32) || defined(PLATFORM_DARWIN)) && defined(PLATFORM_DESKTOP)
/*
** The MGMT_TUNNEL_SUPPORTED define is used to track the platforms where
** the management tunnel feature is supported.
*/
#define MGMT_TUNNEL_SUPPORTED
#endif

#if (defined(_WIN32) && defined(PLATFORM_DESKTOP)) || defined(MGMT_TUNNEL_SUPPORTED)
// Machine certificate authentication SSL tunnel connections via agent are supported
// on Windows desktop, and also on all platforms supporting the management tunnel feature.
//
#define SSL_CONNECT_VIA_AGENT_SUPPORTED
#endif

/*
** Performance optimization for the tunnel packet processing loop to attempt to process 
** multiple packets before calling back into select().
*/
#if !defined(_WIN32)
#define MULTI_TUN_PACKET_PROCESSING_SUPPORTED
#endif

#if (defined(_WIN32) && defined(_M_ARM64))
/*
** Disable Hostscan on Windows native ARM64 builds.
*/
#define ANYCONNECT_NO_CSD
#endif
#if defined(_WIN32) && defined(PLATFORM_DESKTOP) && !defined(_M_ARM64) && !defined(X86_FOR_ARM64)
/*
** Connected Standby is supported in Windows desktop but not UWP and not ARM64 (both native ARM64 and the hybrid _WIN32_FOR_ARM64).
*/
#define CONNECTED_STANDBY_SUPPORTED
#endif

#if defined(_WIN32) && defined(PLATFORM_DESKTOP) || defined(PLATFORM_APPLE_SSLVPN)
/*
** This define is used to track platforms where multi-line logs are readable, and hence supported.
*/
#define MULTI_LINE_LOGS_SUPPORTED
#endif

#if defined(PLATFORM_ANDROID)
#define PBR_SUPPORTED
#endif

#if (defined(PBR_SUPPORTED) && defined(PLATFORM_APPLE_SSLVPN) && defined(SUBPLATFORM_IPHONE))
#define USERSPACE_DNS_CACHE_SUPPORTED;
#endif

#if defined (PLATFORM_ANDROID)
#define PCAP_VA_SUPPORTED
#endif

/*
 * Platforms that support Unix Domain Socket.
 */
#if defined(PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN)
#define UNIX_DOMAIN_SOCKET_SUPPORTED
#endif

/* END OF MACRO HELL */
#endif /*__GENDEFS_H*/
